<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ColorProduct extends Model 
{

    protected $table = 'color_product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function picture()
    {
        return $this->hasMany('ProductPicture');
    }

    public function color()
    {
        return $this->belongsTo('Color');
    }

}